# Project Name - Cascaded Clustering Framework

## Overview

This project is organized into two main stages for clustering: Stage-One and Stage-Two. 

### Stage-One Clustering

The Stage-One folder contains the preprocessing and feature engineering steps. Here's an overview of the files:

1. `run_preproc_feat_engg.py`: This Python script is used to run preprocessing and feature engineering on custom datasets. The dataset to be processed should be specified in the `constants.py` file.

2. `constants.py`: This file contains constants and configuration settings for the preprocessing and feature engineering stage. You can specify the input dataset (.csv file) here.

3. `run_experiment.py`: This script runs the actual clustering on the engineered features. It uses the configuration settings from `config.py`.

4. `config.py`: This file contains configuration requirements for the clustering experiment, such as the number of clusters and other hyperparameters.

### Stage-Two Clustering

In Stage-Two, we include our LSTM + GCN model for reference.

## Usage

To use the Stage-One clustering:

1. Run `run_preproc_feat_engg.py` to preprocess and engineer features from your custom dataset. Make sure to specify the dataset file in `constants.py`.

2. Configure the clustering parameters in `config.py` for your specific experiment.

3. Run `run_experiment.py` to perform clustering on the engineered features using the specified parameters in `constants.py`

For the Stage-Two clustering, you can refer to the LSTM + GCN model provided in the respective folder for more advanced clustering techniques.

## Requirements

- Python 3.x
- PyTorch Geometric



